/*
 * Decompiled with CFR 0.152.
 */
import java.awt.AWTEvent;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.Rectangle2D;
import java.text.NumberFormat;
import java.util.StringTokenizer;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.border.TitledBorder;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.swing.event.MouseInputListener;

public class Equator
extends JFrame
implements AWTEventListener {
    static final int startSize = 500;
    static final int minSize = 350;
    static Equator E;
    static JTextArea ta;
    JToggleButton mv;
    JToggleButton bb;
    JToggleButton mg;
    JToggleButton zg;
    JGraph g;
    static JToggleButton selected;

    public static void main(String[] stringArray) {
        E = new Equator();
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Dimension dimension = toolkit.getScreenSize();
        E.setSize(500, 500);
        E.setMinimumSize(new Dimension(350, 350));
        E.setLocation((int)dimension.getWidth() / 2 - 250, (int)dimension.getHeight() / 2 - 250);
        E.setDefaultCloseOperation(3);
        E.setTitle("Equator");
        E.setVisible(true);
    }

    public void eventDispatched(AWTEvent aWTEvent) {
        ta.append(aWTEvent + "\n");
    }

    static void changeSelected(JToggleButton jToggleButton) {
        if (selected != null) {
            selected.setSelected(true);
        }
        selected = jToggleButton;
        selected.setSelected(false);
    }

    static void setSize(JComponent jComponent, int n, int n2) {
        jComponent.setMinimumSize(new Dimension(n, n2));
        jComponent.setMaximumSize(new Dimension(n, n2));
        jComponent.setPreferredSize(new Dimension(n, n2));
    }

    Equator() {
        ClassLoader classLoader = ClassLoader.getSystemClassLoader();
        Container container = this.getContentPane();
        container.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 50;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 2));
        jPanel.setBorder(new TitledBorder(null, "Equation", 1, 2));
        Equator.setSize(jPanel, 500, 60);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        container.add((Component)jPanel, gridBagConstraints);
        this.mv = new JToggleButton(new ImageIcon(classLoader.getResource("move.png")), true);
        Equator.setSize(this.mv, n, n);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        container.add((Component)this.mv, gridBagConstraints);
        this.mv.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Equator.this.g.action = 0;
                Equator.changeSelected(Equator.this.mv);
            }
        });
        Equator.changeSelected(this.mv);
        this.bb = new JToggleButton(new ImageIcon(classLoader.getResource("bend.png")), true);
        Equator.setSize(this.bb, n, n);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        container.add((Component)this.bb, gridBagConstraints);
        this.bb.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Equator.this.g.action = 1;
                Equator.changeSelected(Equator.this.bb);
            }
        });
        this.mg = new JToggleButton(new ImageIcon(classLoader.getResource("moveg.png")), true);
        Equator.setSize(this.mg, n, n);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        container.add((Component)this.mg, gridBagConstraints);
        this.mg.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Equator.this.g.action = 2;
                Equator.changeSelected(Equator.this.mg);
            }
        });
        this.zg = new JToggleButton(new ImageIcon(classLoader.getResource("zoom.png")), true);
        Equator.setSize(this.zg, n, n);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 0;
        container.add((Component)this.zg, gridBagConstraints);
        this.zg.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Equator.this.g.action = 3;
                Equator.changeSelected(Equator.this.zg);
            }
        });
        this.g = new JGraph(jPanel);
        this.g.setOpaque(true);
        this.g.addMouseListener(this.g);
        this.g.addMouseMotionListener(this.g);
        this.g.addComponentListener(this.g);
        JData jData = new JData(this.g);
        jData.setBorder(new TitledBorder(null, "", 3, 5));
        jData.setOpaque(false);
        this.g.setLayout(new BorderLayout());
        this.g.add((Component)jData, "Center");
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 2, 2, 2);
        gridBagConstraints.fill = 1;
        container.add((Component)this.g, gridBagConstraints);
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = new JMenu("Enter Data");
        jMenu.setMnemonic(68);
        jMenuBar.add(jMenu);
        jMenu.addMenuListener(jData);
        JMenu jMenu2 = new JMenu("Equations");
        jMenu2.setMnemonic(69);
        jMenuBar.add(jMenu2);
        JMenuItem jMenuItem = new JMenuItem("Exponential");
        JMenuItem jMenuItem2 = new JMenuItem("Quadratic");
        JMenuItem jMenuItem3 = new JMenuItem("Reciprocal");
        JMenuItem jMenuItem4 = new JMenuItem("Linear");
        jMenu2.add(jMenuItem4);
        jMenu2.add(jMenuItem2);
        jMenu2.add(jMenuItem3);
        jMenu2.add(jMenuItem);
        jMenuItem.addActionListener(this.g);
        jMenuItem2.addActionListener(this.g);
        jMenuItem3.addActionListener(this.g);
        jMenuItem4.addActionListener(this.g);
        JMenu jMenu3 = new JMenu("Line Colour");
        jMenu3.setMnemonic(67);
        jMenuBar.add(jMenu3);
        JMenuItem jMenuItem5 = new JMenuItem("Red");
        JMenuItem jMenuItem6 = new JMenuItem("Green");
        JMenuItem jMenuItem7 = new JMenuItem("Blue");
        jMenu3.add(jMenuItem5);
        jMenu3.add(jMenuItem6);
        jMenu3.add(jMenuItem7);
        jMenuItem5.addActionListener(this.g);
        jMenuItem6.addActionListener(this.g);
        jMenuItem7.addActionListener(this.g);
        JMenu jMenu4 = new JMenu("Line Size");
        jMenu4.setMnemonic(83);
        jMenuBar.add(jMenu4);
        JMenuItem jMenuItem8 = new JMenuItem("1");
        JMenuItem jMenuItem9 = new JMenuItem("2");
        JMenuItem jMenuItem10 = new JMenuItem("3");
        JMenuItem jMenuItem11 = new JMenuItem("4");
        jMenu4.add(jMenuItem8);
        jMenu4.add(jMenuItem9);
        jMenu4.add(jMenuItem10);
        jMenu4.add(jMenuItem11);
        jMenuItem8.addActionListener(this.g);
        jMenuItem9.addActionListener(this.g);
        jMenuItem10.addActionListener(this.g);
        jMenuItem11.addActionListener(this.g);
        JMenu jMenu5 = new JMenu("Reset Graph");
        jMenu5.setMnemonic(82);
        jMenuBar.add(jMenu5);
        jMenu5.addMenuListener(new MenuListener(){

            public void menuDeselected(MenuEvent menuEvent) {
            }

            public void menuCanceled(MenuEvent menuEvent) {
            }

            public void menuSelected(MenuEvent menuEvent) {
                Equator.this.g.defaultValues();
            }
        });
        jMenuBar.add(new JSeparator());
        JMenu jMenu6 = new JMenu("Exit");
        jMenu6.setMnemonic(88);
        jMenuBar.add(jMenu6);
        jMenu6.addMenuListener(new MenuListener(){

            public void menuDeselected(MenuEvent menuEvent) {
            }

            public void menuCanceled(MenuEvent menuEvent) {
            }

            public void menuSelected(MenuEvent menuEvent) {
                System.exit(0);
            }
        });
        this.setJMenuBar(jMenuBar);
    }

    static {
        ta = new JTextArea("");
    }

    public class JData
    extends JComponent
    implements MenuListener {
        int NDV = 1000;
        Color c = Color.black;
        int ps = 5;
        int data = 0;
        double[] datax = new double[this.NDV];
        double[] datay = new double[this.NDV];
        NumberFormat nf = NumberFormat.getInstance();
        JGraph jg;
        JFrame w = new JFrame();
        JDataField[] tfx = new JDataField[this.NDV];
        JDataField[] tfy = new JDataField[this.NDV];

        JData(JGraph jGraph) {
            int n;
            this.jg = jGraph;
            this.w.setLayout(new BorderLayout());
            this.w.setTitle("Enter Data...");
            this.w.setSize(200, 500);
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new GridLayout(1, 2));
            JLabel jLabel = new JLabel("X");
            jLabel.setHorizontalAlignment(0);
            JLabel jLabel2 = new JLabel("Y");
            jLabel2.setHorizontalAlignment(0);
            jPanel.add(jLabel);
            jPanel.add(jLabel2);
            JPanel jPanel2 = new JPanel();
            jPanel2.setLayout(new GridLayout(this.NDV, 2));
            for (n = 0; n < this.NDV; ++n) {
                this.tfx[n] = new JDataField(3);
                this.tfy[n] = new JDataField(3);
                if (n < this.data) {
                    this.tfx[n].setText("" + this.nf.format(this.datax[n]));
                    this.tfy[n].setText("" + this.nf.format(this.datay[n]));
                }
                jPanel2.add(this.tfx[n]);
                jPanel2.add(this.tfy[n]);
            }
            for (n = 0; n < this.NDV; ++n) {
                this.tfx[n].setNext(this.tfy[n]);
                if (n >= this.NDV - 1) continue;
                this.tfy[n].setNext(this.tfx[n + 1]);
            }
            JPanel jPanel3 = new JPanel();
            jPanel3.setLayout(new GridLayout(1, 2));
            JButton jButton = new JButton("Update");
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    JData.this.datax = new double[JData.this.NDV];
                    JData.this.datay = new double[JData.this.NDV];
                    int n = 0;
                    for (int i = 0; i < JData.this.NDV; ++i) {
                        Double d;
                        Double d2;
                        try {
                            d2 = Double.valueOf(JData.this.tfx[i].getText());
                            d = Double.valueOf(JData.this.tfy[i].getText());
                        }
                        catch (Exception exception) {
                            continue;
                        }
                        JData.this.datax[n] = d2;
                        JData.this.datay[n] = d;
                        ++n;
                    }
                    JData.this.data = n;
                    JData.this.repaint();
                }
            });
            jPanel3.add(jButton);
            JButton jButton2 = new JButton("Clear All");
            jButton2.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    for (int i = 0; i < JData.this.NDV; ++i) {
                        JData.this.tfx[i].setText("");
                        JData.this.tfy[i].setText("");
                    }
                    JData.this.data = 0;
                }
            });
            jPanel3.add(jButton2);
            JPanel jPanel4 = new JPanel();
            jPanel4.setLayout(new BorderLayout());
            jPanel4.add((Component)jPanel, "North");
            jPanel4.add((Component)new JScrollPane(jPanel2), "Center");
            jPanel4.add((Component)jPanel3, "South");
            this.w.add((Component)jPanel4, "Center");
        }

        protected void paintComponent(Graphics graphics) {
            Color color = graphics.getColor();
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setColor(new Color(0, 0, 0, 1));
            graphics2D.fillRect(0, 0, this.jg.appw, this.jg.apph);
            graphics2D.setColor(this.c);
            for (int i = 0; i < this.data; ++i) {
                graphics2D.fillOval(this.jg.xView(this.datax[i]) - this.ps / 2, this.jg.yView(this.datay[i]) - this.ps / 2, this.ps, this.ps);
            }
            graphics2D.setColor(color);
        }

        public void menuCanceled(MenuEvent menuEvent) {
        }

        public void menuDeselected(MenuEvent menuEvent) {
        }

        public void menuSelected(MenuEvent menuEvent) {
            this.w.setVisible(true);
        }

        class JDataField
        extends JTextField {
            JDataField next = null;

            JDataField(int n) {
                super(n);
            }

            public void setNext(JDataField jDataField) {
                this.next = jDataField;
            }

            public void paste() {
                try {
                    Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                    this.getToken(new StringTokenizer((String)clipboard.getData(DataFlavor.stringFlavor)));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }

            public void getToken(StringTokenizer stringTokenizer) {
                this.setText("" + stringTokenizer.nextToken());
                if (this.next != null) {
                    this.next.getToken(stringTokenizer);
                }
            }
        }
    }

    public class JGraph
    extends JComponent
    implements MouseInputListener,
    ActionListener,
    ComponentListener {
        NumberFormat nf = NumberFormat.getInstance();
        Formula f;
        Color c = Color.blue;
        int lt;
        int apph;
        int appw;
        JPanel eqp;
        int action;
        static final int MOVE = 0;
        static final int BEND = 1;
        static final int CENTER = 2;
        static final int ZOOM = 3;
        Font bf;
        Font af;
        FontRenderContext fr;
        private double dimx;
        private double dimy;
        private double cx;
        private double cy;
        int atX;
        int atY;
        int nwX;
        int nwY;
        int zX;
        int zY;
        boolean zooming = false;

        JGraph(JPanel jPanel) {
            this.eqp = jPanel;
            this.setFormula(new X());
            this.defaultValues();
        }

        public void defaultValues() {
            this.cx = 0.0;
            this.cy = 0.0;
            this.dimx = 20.0;
            this.dimy = 20.0;
            this.lt = 2;
            this.repaint();
        }

        protected void paintComponent(Graphics graphics) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            Color color = graphics2D.getColor();
            if (this.bf == null) {
                this.bf = graphics2D.getFont();
                this.af = this.bf.deriveFont(10.0f);
                this.fr = graphics2D.getFontMetrics(this.bf).getFontRenderContext();
            }
            graphics2D.setColor(this.getBackground());
            graphics2D.fillRect(0, 0, this.appw, this.apph);
            graphics2D.setStroke(new BasicStroke(this.lt));
            graphics2D.setColor(this.c);
            this.plotFormula(graphics2D, this.f);
            graphics2D.setStroke(new BasicStroke(1.0f));
            graphics2D.setColor(Color.darkGray);
            this.drawAxes(graphics2D);
            graphics2D.setColor(Color.green.darker().darker());
            P p = this.cartesianToViewpoint(this.cx, this.cy);
            graphics2D.fillOval((int)p.x - 2, (int)p.y - 2, 5, 5);
            graphics2D.setColor(Color.black);
            String string = "(" + this.nf.format(this.xCart(this.atX)) + ", " + this.nf.format(this.yCart(this.atY)) + ")";
            Rectangle2D.Double double_ = new Rectangle2D.Double();
            TextLayout textLayout = new TextLayout(string, this.bf, this.fr);
            double_.setRect(textLayout.getBounds());
            graphics2D.drawString(string, 1, (int)double_.getHeight() + 1);
            if (this.action == 3 && this.zooming) {
                graphics2D.setStroke(new BasicStroke(2.0f));
                graphics2D.setColor(Color.orange);
                int n = Math.min(this.zX, this.atX);
                int n2 = Math.min(this.zY, this.atY);
                int n3 = Math.abs(this.atX - this.zX);
                int n4 = Math.abs(this.atY - this.zY);
                graphics2D.drawRect(n, n2, n3, n4);
            }
            graphics2D.setColor(color);
            this.f.display();
        }

        void plotFormula(Graphics2D graphics2D, Formula formula) {
            double d = this.dimx / 2.0;
            double d2 = this.dimx / (double)this.appw;
            P p = new P(this.cx + -d, formula.y(this.cx + -d));
            for (double d3 = this.cx + -d + d2; d3 < this.cx + d; d3 += d2) {
                P p2 = new P(d3, formula.y(d3));
                if (formula.connect(p, p2)) {
                    graphics2D.drawLine(this.xView(p.x), this.yView(p.y), this.xView(p2.x), this.yView(p2.y));
                }
                p = p2;
            }
        }

        void drawAxes(Graphics2D graphics2D) {
            double d;
            int n = 3;
            double d2 = this.dimx / 2.0;
            double d3 = this.dimy / 2.0;
            graphics2D.setFont(this.af);
            P p = this.cartesianToViewpoint(this.cx - d2, 0.0);
            P p2 = this.cartesianToViewpoint(this.cx + d2, 0.0);
            graphics2D.drawLine((int)p.x, (int)p.y, (int)p2.x, (int)p2.y);
            double d4 = this.dimx / 10.0;
            double d5 = Math.floor(this.cx - d2);
            d5 -= d5 % (this.dimx / 10.0);
            for (d = d5; d <= this.cx + d2; d += d4) {
                p = this.cartesianToViewpoint(d, 0.0);
                graphics2D.drawLine((int)p.x, (int)p.y - n, (int)p.x, (int)p.y + n);
                graphics2D.drawString(this.nf.format(d), (int)p.x, (int)p.y - 3);
            }
            p = this.cartesianToViewpoint(0.0, this.cy - d3);
            p2 = this.cartesianToViewpoint(0.0, this.cy + d3);
            graphics2D.drawLine((int)p.x, (int)p.y, (int)p2.x, (int)p2.y);
            d4 = this.dimy / 10.0;
            d5 = Math.floor(this.cy - d3);
            d5 -= d5 % (this.dimy / 10.0);
            for (d = d5; d <= this.cy + d3; d += d4) {
                if (!(d > 1.0E-10) && !(d < -1.0E-10)) continue;
                p = this.cartesianToViewpoint(0.0, d);
                graphics2D.drawLine((int)p.x - n, (int)p.y, (int)p.x + n, (int)p.y);
                graphics2D.drawString(this.nf.format(d), (int)p.x + 5, (int)p.y);
            }
            graphics2D.setFont(this.bf);
        }

        P cartesianToViewpoint(double d, double d2) {
            return new P(this.xView(d), this.yView(d2));
        }

        P viewpointToCartesian(int n, int n2) {
            return new P(this.xCart(n), this.yCart(n2));
        }

        int xView(double d) {
            double d2 = ((d - this.cx) / this.dimx + 0.5) * (double)this.appw;
            if (d2 < -2.147483648E9) {
                d2 = -2.1474836E7;
            } else if (d2 > 2.147483647E9) {
                d2 = 2.1474836E7;
            }
            return (int)d2;
        }

        int yView(double d) {
            double d2 = (-(d - this.cy) / this.dimy + 0.5) * (double)this.apph;
            if (d2 < -2.147483648E9) {
                d2 = -2.1474836E7;
            } else if (d2 > 2.147483647E9) {
                d2 = 2.1474836E7;
            }
            return (int)d2;
        }

        double xCart(int n) {
            return ((double)n / (double)this.appw - 0.5) * this.dimx + this.cx;
        }

        double yCart(int n) {
            return ((double)n / (double)this.apph - 0.5) * -this.dimy + this.cy;
        }

        void setFormula(Formula formula) {
            this.eqp.removeAll();
            this.f = formula;
            this.f.setup(this.eqp);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            switch (string.charAt(0)) {
                case 'E': {
                    this.setFormula(new Expx());
                    break;
                }
                case 'Q': {
                    this.setFormula(new Xsquared2());
                    break;
                }
                case 'R': {
                    switch (string.charAt(2)) {
                        case 'c': {
                            this.setFormula(new Invdx());
                            break;
                        }
                        case 'd': {
                            this.c = Color.red;
                        }
                    }
                    break;
                }
                case 'L': {
                    this.setFormula(new X());
                    break;
                }
                case 'G': {
                    this.c = Color.green;
                    break;
                }
                case 'B': {
                    this.c = Color.blue;
                    break;
                }
                case '1': {
                    this.lt = 1;
                    break;
                }
                case '2': {
                    this.lt = 2;
                    break;
                }
                case '3': {
                    this.lt = 3;
                    break;
                }
                case '4': {
                    this.lt = 4;
                }
            }
            this.repaint();
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.zX = mouseEvent.getX();
            this.zY = mouseEvent.getY();
            switch (this.action) {
                case 3: {
                    this.zooming = true;
                }
            }
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            this.atX = mouseEvent.getX();
            this.atY = mouseEvent.getY();
            this.repaint();
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            switch (this.action) {
                case 3: {
                    if (n == this.zX || n2 == this.zY) {
                        this.dimy *= 10.0;
                        this.dimx *= 10.0;
                        if (this.dimx > 1.0) {
                            this.dimx = Math.ceil(this.dimx);
                        }
                        if (this.dimy > 1.0) {
                            this.dimy = Math.ceil(this.dimy);
                        }
                    } else {
                        double d = this.xCart(this.zX);
                        double d2 = this.xCart(this.atX);
                        double d3 = this.yCart(this.zY);
                        double d4 = this.yCart(this.atY);
                        this.dimx = Math.abs(d - d2);
                        this.dimy = Math.abs(d3 - d4);
                        if (this.dimx > 1.0) {
                            this.dimx = Math.ceil(this.dimx);
                        }
                        if (this.dimy > 1.0) {
                            this.dimy = Math.ceil(this.dimy);
                        }
                        this.cx = Math.min(d, d2) + this.dimx / 2.0;
                        this.cy = Math.min(d3, d4) + this.dimy / 2.0;
                    }
                    if (this.dimy > 20000.0) {
                        this.dimy = 20000.0;
                    }
                    if (this.dimy < 0.02) {
                        this.dimy = 0.02;
                    }
                    if (this.dimx > 20000.0) {
                        this.dimx = 20000.0;
                    }
                    if (this.dimx < 0.02) {
                        this.dimx = 0.02;
                    }
                    this.zooming = false;
                    this.repaint();
                }
            }
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            this.nwY = mouseEvent.getY();
            this.nwX = mouseEvent.getX();
            switch (this.action) {
                case 0: {
                    this.f.vShift(this.dimy / (double)this.apph * (double)(this.atY - this.nwY));
                    this.f.hShift(this.dimx / (double)this.appw * (double)(this.atX - this.nwX));
                    break;
                }
                case 1: {
                    double d = this.xCart(this.zX);
                    this.f.vChange(new P(d, this.f.y(d)), this.viewpointToCartesian(this.atX, this.atY));
                    break;
                }
                case 2: {
                    this.cy -= this.dimy / (double)this.apph * (double)(this.atY - this.nwY);
                    this.cx += this.dimx / (double)this.appw * (double)(this.atX - this.nwX);
                }
            }
            this.repaint();
            this.mouseMoved(mouseEvent);
        }

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        public void componentHidden(ComponentEvent componentEvent) {
        }

        public void componentMoved(ComponentEvent componentEvent) {
        }

        public void componentResized(ComponentEvent componentEvent) {
            this.apph = this.getHeight();
            this.appw = this.getWidth();
        }

        public void componentShown(ComponentEvent componentEvent) {
        }
    }
}

