/* Graph (http://sourceforge.net/projects/graph)
 * Copyright 2007 Ivan Johansen
 *
 * Graph is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 */
//---------------------------------------------------------------------------
#include "Graph.h"
#pragma hdrstop
#include "Unit17.h"
//---------------------------------------------------------------------------
#pragma link "Grid"
#pragma link "TntMenus"
#pragma link "TntStdCtrls"
#pragma resource "*.dfm"
//---------------------------------------------------------------------------
__fastcall TForm17::TForm17(TComponent* Owner, TData &AData)
  : TTntForm(Owner), Data(AData)
{
  ScaleForm(this);
  TranslateProperties(this);
  SetAccelerators(this);
  Grid1->ColWidths[1] = Grid1->Width - Grid1->ColWidths[0] - GetSystemMetrics(SM_CXHTHUMB) - 6;

  unsigned I = 1;
  Grid1->RowCount = Data.CustomFunctions.End() - Data.CustomFunctions.Begin() + 2;
  for(TCustomFunctions::ConstIterator Iter = Data.CustomFunctions.Begin(); Iter != Data.CustomFunctions.End(); ++Iter, I++)
  {
    Grid1->Cells[0][I] = Iter->GetName().c_str();
    Grid1->Cells[1][I] = Iter->Text.c_str();
  }
}
//---------------------------------------------------------------------------
void __fastcall TForm17::Button4Click(TObject *Sender)
{
  Application->HelpContext(HelpContext);
}
//---------------------------------------------------------------------------
void __fastcall TForm17::Button1Click(TObject *Sender)
{
  Button3->Click();
  ModalResult = mrOk;
}
//---------------------------------------------------------------------------
void __fastcall TForm17::Button3Click(TObject *Sender)
{
  int Index = 1;
  try
  {
    TCustomFunctions CustomFunctions;
    for(Index = 1; Index < Grid1->RowCount; Index++)
      if(!Grid1->Cells[0][Index].IsEmpty() || !Grid1->Cells[1][Index].IsEmpty())
        CustomFunctions.Add(Grid1->Cells[0][Index].c_str(), Grid1->Cells[1][Index].c_str());

    CustomFunctions.Update();
    Data.AbortUpdate();
    Data.CustomFunctions.Swap(CustomFunctions);
    UndoList.Push(TUndoCustomFunctions(CustomFunctions));
    Data.Update();
  }
  catch(Func32::EFuncError &E)
  {
    if(Index < Grid1->RowCount)
    {
      Grid1->Row = Index;
      Grid1->Col = 1;
      Grid1->SetFocus();
    }
    ShowErrorMsg(E);
    throw EAbort("");
  }
  catch(ECustomFunctionError &E)
  {
    Grid1->SetFocus();
    if(E.ErrorCode == cfeParseError)
    {
      Grid1->Row = E.ErrorPos + 1;
      Grid1->Col = 1;
      Grid1->SetCursorPos(E.ParseError.ErrorPos);
      ShowErrorMsg(E.ParseError);
    }
    else
    {
      Grid1->Row = Index;
      Grid1->Col = 0;
      Grid1->SetCursorPos(E.ErrorPos);
      ShowErrorMsg(E);
    }
    throw EAbort("");
  }

  Data.SetModified();
  Data.ClearCache();
  Form1->Redraw();
}
//---------------------------------------------------------------------------
void __fastcall TForm17::Popup_InsertClick(TObject *Sender)
{
  Grid1->InsertRows(Grid1->Row, 1);
}
//---------------------------------------------------------------------------
void __fastcall TForm17::Popup_RemoveClick(TObject *Sender)
{
  Grid1->RemoveRows(Grid1->Selection.Top, Grid1->Selection.Bottom - Grid1->Selection.Top + 1);
}
//---------------------------------------------------------------------------
void __fastcall TForm17::Grid1EditorKeyPress(TInplaceEdit *InplaceEdit, char &Key)
{
  if(Key == '\n')
    Button1->Click();
}
//---------------------------------------------------------------------------
void __fastcall TForm17::Popup_CutClick(TObject *Sender)
{
  Grid1->CutToClipboard();
}
//---------------------------------------------------------------------------
void __fastcall TForm17::Popup_CopyClick(TObject *Sender)
{
  Grid1->CopyToClipboard();
}
//---------------------------------------------------------------------------
void __fastcall TForm17::Popup_PasteClick(TObject *Sender)
{
  Grid1->PasteFromClipboard();
}
//---------------------------------------------------------------------------
void __fastcall TForm17::Popup_DeleteClick(TObject *Sender)
{
  Grid1->ClearSelection();
}
//---------------------------------------------------------------------------
void __fastcall TForm17::Popup_SelectClick(TObject *Sender)
{
  Grid1->SelectAll();
}
//---------------------------------------------------------------------------
void __fastcall TForm17::Popup_ImportClick(TObject *Sender)
{
  OpenDialog1->Filter = LoadRes(RES_DATA_FILTER);
  if(OpenDialog1->Execute())
    Grid1->ImportFromFile(OpenDialog1->FileName);
}
//---------------------------------------------------------------------------
void __fastcall TForm17::Popup_ExportClick(TObject *Sender)
{
  SaveDialog1->Filter = LoadRes(RES_EXPORT_DATA_FILTER);
  if(SaveDialog1->Execute())
    if(!Grid1->ExportToFile(SaveDialog1->FileName, SaveDialog1->FilterIndex == 1 ? ';' : '\t'))
      MessageBox(LoadRes(RES_FILE_ACCESS, SaveDialog1->FileName), LoadStr(RES_WRITE_FAILED), MB_ICONSTOP);
}
//---------------------------------------------------------------------------

